#!/usr/bin/env python3.11

# Copyright 2024, Gurobi Optimization, LLC

import gurobipy as gp
from gurobipy import GRB

import pandas as pd
import xlrd
from openpyxl import Workbook
from openpyxl import load_workbook

import time

# YOU MUST PUT sheet_name=None TO READ ALL SHEETS IN YOUR XLSM FILE
xlsm_file = "Modelo_Abdullah(2016)_v3 - Copia - Copia.xlsm"
df = pd.read_excel(xlsm_file, sheet_name='Planilha2', header=None)

# prints all sheets
# print(df)pip install xlrd

# Super Toy Problem

T=df.iloc[5,1]
J=df.iloc[2,1]
M = df.iloc[13,1]
A = df.iloc[12,1]
S = df.iloc[11,1]


C=[]
idx,idy = (17,1)
for t in range(T):
    temp = []
    for j in range(J):
        temp.append(df.iloc[idx+t,idy+j])
    C.append(temp)

N=[]
idx_n = 32
for t in range(T):
    temp1 = []
    idx_n = 32 + 11*t
    for h in range(J):
        temp2 = []
        for j in range(J):
            temp2.append(df.iloc[idx_n+h,1+j])
        temp1.append(temp2)
    N.append(temp1)

D=[]
for t in range(T):
    temp = []
    for j in range(J):
        temp.append(df.iloc[1+t,12+j])
    D.append(temp)


H=[]
for t in range(T):
    temp = []
    for j in range(J):
        temp.append(df.iloc[17+t,12+j])
    H.append(temp)
    
O=[]
idx_n = 32
for t in range(T):
    temp1 = []
    idx_n = 32 + 11*t
    for h in range(J):
        temp2 = []
        for j in range(J):
            temp2.append(df.iloc[idx_n+h,12+j])
        temp1.append(temp2)
    O.append(temp1)

C1=[]
idx,idy = (1,23)
for t in range(T):
    C1.append(df.iloc[idx+t,idy])

C2=[]
idx,idy = (17,23)
for t in range(T):
    temp = []
    for j in range(J):
        temp.append(df.iloc[idx+t,idy+j])
    C2.append(temp)
    
C3=[]
idx,idy = (32,23)
for t in range(T):
    temp = []
    for j in range(J):
        temp.append(df.iloc[idx+t,idy+j])
    C3.append(temp)
    

# Range of time and grade
time = range(T)
grade = range(J)

# Model

m = gp.Model("off-grade")
m.ModelSense = GRB.MINIMIZE

# Declare decison variables
x = m.addVars(grade, time, vtype=GRB.CONTINUOUS, name="(x)")
I = m.addVars(grade, time, vtype=GRB.CONTINUOUS, name="(I)")
y = m.addVars(grade, time, vtype=GRB.BINARY, name="(y)")
f = m.addVars(grade, time, vtype=GRB.BINARY, name="(f)")
z = m.addVars(time,grade,grade, vtype=GRB.BINARY, name="(z)")

sa = m.addVars(time, vtype=GRB.CONTINUOUS, name="(sa)")
aw = m.addVars(grade, time, vtype=GRB.CONTINUOUS, name="(aw)")
wc = m.addVars(grade, time, vtype=GRB.CONTINUOUS, name="(wc)")


# Using looping constructs, the preceding statement would be:
#
obj = sum(x[j,t]*C[t][j] for j in grade for t in time)
obj += sum(N[t][j][h]*O[t][j][h]*z[t,j,h] for j in grade for h in grade for t in time)
obj += sum(I[j,t]*H[t][j] for j in grade for t in time)
obj += sum(sa[t]*C1[t] for t in time)
obj += sum(aw[j,t]*C2[t][j] for j in grade for t in time)
obj += sum(wc[j,t]*C3[t][j] for j in grade for t in time)

m.setObjective(obj, GRB.MINIMIZE)

# Supplier Capacity Constraint
m.addConstrs((sa.sum(t) <= S for t in time), name="SupplierCapacityConstraint")

# Plant Capacity Constraint

constr1 = (x.sum(j,t) for j in range(J) for t in range(T))
# constr1 += (gp.quicksum(O[j] * z[t,j,h] for j in range(J) for h in range(J) for t in range(T)))
# constraints = m.addConstrs((gp.quicksum(x[j,t] for j in range(J) for t in range(T)) <= A for i in I), name="constraint")
m.addConstrs(((gp.quicksum(x[j,t] for j in range(J))) + (gp.quicksum(O[t][h][j] * z[t,j,h] for j in range(J) for h in range(J))) <= A for t in range(T)), name="AffiliateCapacityConstraint")

# Inventory Constraint
# m.addConstrs((x[j,t] + I[j,t-1] == aw[j,t] + I[j,t] for j in grade for t in range(1,T)), name="InventoryConstraint")

'''
Inventory Constraint alt
for t in range(T):
    if t == 0:
        m.addConstrs((x[j,t] == aw[j,t] + I[j,t] for j in grade), name="InventoryConstraint")
    else:
        m.addConstrs((x[j,t] + I[j,t-1] == aw[j,t] + I[j,t] for j in grade for t in range(1,T)), name="InventoryConstraint")
'''


# Inventory Constraint alt
for t in range(T):
    if t == 0:
        m.addConstrs((x[j,t] == aw[j,t] + I[j,t] for j in grade), name="InventoryConstraint")
    else:
        m.addConstrs((x[j,t] + I[j,t-1] == aw[j,t] + I[j,t] for j in grade), name="InventoryConstraint")

        
# Customer Demand
m.addConstrs((wc[j,t] == D[t][j] for j in grade for t in time), name="CustomerDemandConstraint")

# Transport Constraints
m.addConstrs((sa[t] == gp.quicksum(x[j,t] for j in range(J)) for t in time), name="TransportationConstraints")

# Warehouse inventory Constraints
m.addConstrs((aw.sum(j,t) - wc.sum(j,t) == 0 for j in grade for t in time), name="WarehouseInventoryConstraint")

# Sequencing Constraints
m.addConstrs((x[j,t] <= M*y[j,t] for j in grade for t in time), name="SequenceingConstraints (M)")
m.addConstrs((y[j,t] <= x[j,t] for j in grade for t in time), name="SequenceingConstraints (-)")

# Ensure fijt
for t in time:
    for j in range(J-1):
        LHS = y[j+1,t]
        for h in range(j+2,J):
            LHS += y[h,t]
        m.addConstr((LHS <= M*f[j,t]), name="Ensure_fijt (M)")

# Ensure fijt
for t in time:
    for j in range(J-1):
        LHS = y[j+1,t]
        for h in range(j+2,J):
            LHS += y[h,t]
        m.addConstr((LHS >= f[j,t]), name="Ensure_fijt (-)")



m.addConstrs((z[t,j,h] <= 0.5*(y[j,t] + y[h,t]) for j in range(J-1) for h in range(j+1,J) for t in time), name="Ensure1_zijht (0.5)")


m.addConstrs((gp.quicksum(z[t,j,h] for h in range(j+1,J)) >=  y[j,t] + f[j,t] - 1 for j in range(J-1) for t in time), name="Ensure2_zijht")
m.addConstrs((gp.quicksum(z[t,j,h] for j in range(h)) <=  1 for h in range(1,J) for t in time), name="Ensure3_zijht")




def printSolution():
    if m.status == GRB.OPTIMAL:
        print(f"\nZ: {m.ObjVal:g}")
        print("\nX:")
        for j in grade:
            for t in time:
                print(f"  X {x[j, t].X:g} Production of grade {j} @ month {t}")
        print("--------------------------------------")
        print("\nY:")
        for j in grade:
            for t in time:
                print(f"  Y {y[j, t].X:g} Allocation of grade {j} @ month {t}")
        print("--------------------------------------")
        print("\nI:")
        for j in grade:
            for t in time:
                print(f"  I {I[j, t].X:g} Inventory of grade {j} @ month {t}")
        print("--------------------------------------")
        print("\nf:")
        for j in grade:
            for t in time:
                print(f"  f {f[j, t].X:g} Produced of grade higher than {j} @ month {t}")
        print("--------------------------------------")
        print("\nz:")
        for j in grade:
            for h in grade:
                for t in time:
                    print(f"  z {z[t, j, h].X:g} Transitioned {j} to grade {h} @ month {t}")
    else:
        print("No solution")

def writeSolution():
    if m.status == GRB.OPTIMAL:


        wb = load_workbook(xlsm_file,keep_vba=True)
        ws = wb['Planilha2']

        idx,idy = (2,35)
        for j in grade:
            for t in time:
                ws.cell(row=idx+t,column=idy+j).value = x[j,t].X

        idx,idy = (18,35)
        for j in grade:
            for t in time:
                ws.cell(row=idx+t,column=idy+j).value = I[j,t].X

        idx,idy = (33,35)
        for j in grade:
            for t in time:
                ws.cell(row=idx+t,column=idy+j).value = y[j,t].X
        
        idx,idy = (54,35)
        for j in grade:
            for t in time:
                ws.cell(row=idx+t,column=idy+j).value = f[j,t].X

        idx,idy = (75,35)
        for t in time:
            idx = 75+11*t
            for j in grade:
                for h in grade:
                    ws.cell(row=idx+j,column=idy+h).value = z[t, j, h].X
                    # ws.cell(row=idx+j,column=idy+h).value = 999

        idx,idy = (2,46)
        for t in time:
            # ws.cell(row=idx+j,column=idy+t).value = z[j, h, t].X
            ws.cell(row=idx+t,column=idy).value = sa[t].X

        idx,idy = (18,46)
        for j in grade:
            for t in time:
                # ws.cell(row=idx+j,column=idy+t).value = z[j, h, t].X
                ws.cell(row=idx+t,column=idy+j).value = aw[j,t].X

        idx,idy = (33,46)
        for j in grade:
            for t in time:
                ws.cell(row=idx+t,column=idy+j).value = wc[j,t].X
                # ws.cell(row=idx+j,column=idy+t).value = 999

        wb.save(xlsm_file)
                
                
    else:
        print("No solution")

# Solve
m.write("model.lp")
m.optimize()
printSolution()
writeSolution()

print(m.Runtime)